/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#if !defined (_BMCL_H_)
#define _BMCL_H_



typedef struct _BMCL_bufid_info_t {
	UINT32 size;        
	UINT32 start_adr;   
	UINT32 phy_adr;     
	UINT32 phymem_adr;  
} BMCL_bufid_info_t;

typedef struct _BMCL_connect_buf_t {
	UINT32            buf_id;       
	BMCL_bufid_info_t bufid_info;   
} BMCL_connect_buf_t;

#define BMCL_BM_SINGLE     1 
#define BMCL_BM_CONNECTED  2 

#define BMCL_CH_0   1        
#define BMCL_CH_1   2        

#define BMCL_CACHE_VALID   0 
#define BMCL_CACHE_INVALID 1 

#define BMCL_E_OK            0x00000000 
#define BMCL_E_PARAM         0x81000001 
#define BMCL_E_SEQUENCE      0x81000002 
#define BMCL_E_NOINIT        0x81000003 
#define BMCL_E_NORESOURCE    0x81000004 
#define BMCL_E_SYSTEM        0x81000005 
#define BMCL_E_NOSUPPORT     0x81000006 
#define BMCL_E_BUSY          0x81000007 
#define BMCL_E_DIFFERENTCH   0x81000010 
#define BMCL_E_NOBUF         0x81000011 

INT32 BMCL_init( void );
INT32 BMCL_term( void );

INT32 BMCL_alloc_buf( UINT32 size, UINT8 mode, UINT8 ch, UINT32 *buf_id );
INT32 BMCL_release_buf( UINT32 buf_id );
INT32 BMCL_assign_id_buf( BMCL_bufid_info_t *bufid_info, UINT8 mode, UINT32 *buf_id );
INT32 BMCL_release_id_buf(UINT32 buf_id );
INT32 BMCL_get_bufmode( UINT32 buf_id, UINT8 *mode );
INT32 BMCL_get_connected_bufnum( UINT32 buf_id, UINT32 *num );
INT32 BMCL_get_bufch( UINT32 buf_id, UINT8 *ch);
INT32 BMCL_get_freearea_bufinfo( UINT32 num, UINT8 mode, UINT8 ch,
                                 UINT32 *free_blk_num, UINT32 *size );
INT32 BMCL_get_bufinfo( UINT32 buf_id, BMCL_bufid_info_t *bufid_info );
INT32 BMCL_increment_refcnt( UINT32 buf_id );
INT32 BMCL_decrement_refcnt( UINT32 buf_id );

INT32 BMCL_connect_buf( UINT32 num, UINT32 *buf_list, UINT32 *buf_id  );
INT32 BMCL_disconnect_buf( UINT32 buf_id );
INT32 BMCL_get_connected_bufinfo( UINT32 buf_id, UINT32 index, UINT32 num,
                               BMCL_connect_buf_t *connect_info );

INT32 BMCL_write_buf( UINT32 buf_id, UINT32 size, UINT32 offset, 
                      UINT32 *buffer );
INT32 BMCL_read_buf( UINT32 buf_id, UINT32 size, UINT32 offset, 
                      UINT32 *buffer );
INT32 BMCL_copy_buf( UINT32 src_buf_id, UINT32 src_offset, UINT32 dst_buf_id,
                     UINT32 dst_offset, UINT32 size );

INT32 BMCL_purge_cache( UINT32 buf_id, UINT32 offset, UINT32 size, UINT8 mode );

INT32 BMCL_fast_write_buf( UINT32 buf_id, UINT32 size, UINT32 offset, 
                      UINT32 *buffer, UINT8 mode );
INT32 BMCL_fast_read_buf( UINT32 buf_id, UINT32 size, UINT32 offset, 
                      UINT32 *buffer, UINT8 mode );
INT32 BMCL_fast_copy_buf( UINT32 src_buf_id, UINT32 src_offset, UINT32 dst_buf_id,
                     UINT32 dst_offset, UINT32 size, UINT8 mode );

INT32 BMCL_dump_buf( UINT32 buf_id, UINT32 offset, UINT32 size );

#endif 

